/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import java.util.Random;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();
    private final CraftItemStack item;

    public CraftFirework(CraftServer server, FireworkRocketEntity entity) {
        super(server, (Projectile)entity);
        ItemStack item = (ItemStack)this.getHandle().m_20088_().m_135370_(FireworkRocketEntity.f_37019_);
        if (item.m_41619_()) {
            item = new ItemStack((ItemLike)Items.f_42688_);
            this.getHandle().m_20088_().m_135381_(FireworkRocketEntity.f_37019_, (Object)item);
        }
        this.item = CraftItemStack.asCraftMirror(item);
        if (this.item.getType() != Material.FIREWORK_ROCKET) {
            this.item.setType(Material.FIREWORK_ROCKET);
        }
    }

    public FireworkRocketEntity getHandle() {
        return (FireworkRocketEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    @Override
    public EntityType getType() {
        return EntityType.FIREWORK;
    }

    @Override
    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)this.item.getItemMeta();
    }

    @Override
    public void setFireworkMeta(FireworkMeta meta) {
        this.item.setItemMeta(meta);
        this.getHandle().f_37023_ = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().m_20088_().markDirty(FireworkRocketEntity.f_37019_);
    }

    @Override
    public void detonate() {
        this.getHandle().f_37023_ = 0;
    }

    @Override
    public boolean isShotAtAngle() {
        return this.getHandle().m_37079_();
    }

    @Override
    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().m_20088_().m_135381_(FireworkRocketEntity.f_37021_, (Object)shotAtAngle);
    }
}

